<?php

namespace App\Modules\Reception\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Visit extends Model 
{

    protected $table = 'visits';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'management_id', 'type', 'status');

    public function management()
    {
        return $this->belongsTo('App\Modules\HR\Entities\Management');
    }

    public function visitors()
    {
        return $this->hasMany('App\Modules\Reception\Entities\Visitor');
    }

    public function employees()
    {
        return $this->belongsToMany('App\Modules\HR\Entities\Employee');
    }

}